﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Configuration.aspx.cs" Inherits="GUI.Web.Base.Pages.Wizdom365" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" style="height: 100%;">

<head>
    <title>Administration - LiveTiles Intranet</title>

    <script src="../scriptloader.js?v=<%=GetWizdomVersion%>"></script>

    <script>
        var isSaaS = false;
        var adminDependencies = ["swaggerUi", 'ui.ace'];
        <%=WizdomClientSideFeatureToggles%>
        var enableCustomModules = "<%=IframeModulesEnabled%>";
        //var urlSpecificConfigurationEnabled = true;
        var sessionId = "<%=SessionId%>";
        var wizdomVersion = "<%=GetWizdomVersion%>";
        var loginName = "<%= string.IsNullOrEmpty(LoginName) ? "" : LoginName.Replace("\\","\\\\")%>";
        wizdomInject(
            wizdomVersion, 
            "/", 
            <%=string.IsNullOrEmpty(BlobUrl) ? "null":"\"" + BlobUrl + "\"" %>, 
            true, 
            true, 
            false,
            <%= PartnerModulesBundle%>,
            null,
            null,
            [],
            null,
            <%= InternalModules%>
        );
        IsModulesTabAvailable = <%=IsModulesTabAvailable.ToString().ToLower()%>;
        IsCustomModulesTabAvailable = <%=IsCustomModulesTabAvailable.ToString().ToLower()%>;
    </script>
</head>

<body ng-cloak style="margin: 0; height: 100%;">
    <div class="wizdom display-table" ng-controller="Wizdom365SuitebarController">
        <div class="wizdom-fixed-row">
            <div class="wizdom-header">
                <div class="wizdom-header-logo">
                    <div class="wizdom-header-title pull-left"></div>
                    <span>{{'v.' + version}}</span>
                    <p ng-hide="statusIcon==''" class="wizdom-header-version-status pull-left">
                        <i ng-class="statusIcon" title="{{statusText}}"></i>
                    </p>
                </div>    
                <div class="wizdom-user pull-right">
                    <img src="<%=UserPictureUrl%>" class="user-photo" onerror="this.style.padding='18px'" />
                    <button class="btn btn-link"><%=Username%></button>
                </div>
            </div>
        </div>
        <div class="wizdom-fixed-row" ng-if="fullConfigLoaded">
            <nav class="navbar navbar-default">
                <ul class="nav wizdom-navbar-nav">
                    <li ng-class="{active:isActive('Home.html')}" ng-click='setContent("Home.html")'>
                        <a href=""><i class="streamline icon-house-1 wizdom-navbar-icon"></i><span class="wizdom-navbar-text">{{'Home' | translate}}</span></a>
                    </li>
                    <li ng-class="{active:isActive('Support.html')}" ng-click='setContent("Support.html")'>
                        <a href=""><i class="streamline icon-headphones-customer-support wizdom-navbar-icon"></i><span class="wizdom-navbar-text">{{'Support' | translate}}</span></a>
                    </li>
                   
                    <% if (IsModulesTabAvailable)
                    { %>
                    <li ng-class="{active:isActive('Modules.html')}" ng-click='setContent("Modules.html")'>
                        <a href=""><i class="streamline icon-module-puzzle wizdom-navbar-icon"></i><span class="wizdom-navbar-text">{{'Modules' | translate}}</span></a>
                    </li>
                   
                    <% } %>
                      <% if (IsCustomModulesTabAvailable)
                    { %>
                    
                    <li ng-class="{active:isActive('CustomModules.html')}" ng-click='setContent("CustomModules.html")'>
                        <a href=""><i class="streamline icon-module-hand-puzzle wizdom-navbar-icon"></i><span class="wizdom-navbar-text">{{'Custom modules' | translate}}</span></a>
                    </li>
                    <% } %>

                    <%--  <% if (IsAnalyticsTabAvailable)
                       { %>
                    <li ng-class="{active:isActive('Analytics')}" ng-click='setContent("Analytics.html")'>
                        <a href=""><i class="glyphicon glyphicon-calendar wizdom-navbar-icon"></i><span class="wizdom-navbar-text">{{'Analytics' | translate}}</span></a>
                    </li>
                    <% } %>--%>

                    <% if (IsAdminTabAvailable)
                       { %>
                    <li ng-class="{active:isActive('Administration.html')}" ng-click='setContent("Administration.html")'>
                        <a href=""><i class="streamline icon-cog-double-2 wizdom-navbar-icon"></i><span class="wizdom-navbar-text">{{'Admin' | translate}}</span></a>
                    </li>
                    <% } %>

                    <li class="ml-auto">
                        <a href="<%=Request.QueryString["SPHostUrl"] %>">
                            <i class="streamline icon-logout-2 wizdom-navbar-icon"></i>
                            <span class="wizdom-navbar-text">{{'Back to Sharepoint' | translate}}</span>
                        </a>
                    </li>
                    <li ng-if>
                        <a href="" ng-click='setContent("Support.html")'>
                            <i class="streamline icon-headphones-customer-support wizdom-navbar-icon wizdom-navbar-icon-empty"></i>
                        </a>
                    </li>
                </ul>
            </nav>
            <wizdom365-license-status></wizdom365-license-status>
        </div>
        <div class="wizdom-flex-row" ng-if="fullConfigLoaded || fullConfigNotAllowed">
            <div class="container-fluid full-height wizdom-fixed-cell" wizdom-include='pageUrl'></div>
        </div>
    </div>
</body>

</html>
